<?php
namespace Skb_Cife;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/*--------------------------
*   Class Ion Icon Manager
* -------------------------*/
class Skb_Cife_Ion_Icon_Manager{

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        $this->init();
    }

    public function init() {

        // Custom icon filter
        add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'skb_cife_ion_icon'] );  

    }

	public function skb_cife_ion_icon( $ion_icons_args = array() ) {

	    // Append new icons
	    $ion_icons = array(
			'ios-add',
			'ios-add-circle',
			'ios-add-circle-outline',
			'ios-airplane',
			'ios-alarm',
			'ios-albums',
			'ios-alert',
			'ios-american-football',
			'ios-analytics',
			'ios-aperture',
			'ios-apps',
			'ios-appstore',
			'ios-archive',
			'ios-arrow-back',
			'ios-arrow-down',
			'ios-arrow-dropdown',
			'ios-arrow-dropdown-circle',
			'ios-arrow-dropleft',
			'ios-arrow-dropleft-circle',
			'ios-arrow-dropright',
			'ios-arrow-dropright-circle',
			'ios-arrow-dropup',
			'ios-arrow-dropup-circle',
			'ios-arrow-forward',
			'ios-arrow-round-back',
			'ios-arrow-round-down',
			'ios-arrow-round-forward',
			'ios-arrow-round-up',
			'ios-arrow-up',
			'ios-at',
			'ios-attach',
			'ios-backspace',
			'ios-barcode',
			'ios-baseball',
			'ios-basket',
			'ios-basketball',
			'ios-battery-charging',
			'ios-battery-dead',
			'ios-battery-full',
			'ios-beaker',
			'ios-bed',
			'ios-beer',
			'ios-bicycle',
			'ios-bluetooth',
			'ios-boat',
			'ios-body',
			'ios-bonfire',
			'ios-book',
			'ios-bookmark',
			'ios-bookmarks',
			'ios-bowtie',
			'ios-briefcase',
			'ios-browsers',
			'ios-brush',
			'ios-bug',
			'ios-build',
			'ios-bulb',
			'ios-bus',
			'ios-business',
			'ios-cafe',
			'ios-calculator',
			'ios-calendar',
			'ios-call',
			'ios-camera',
			'ios-car',
			'ios-card',
			'ios-cart',
			'ios-cash',
			'ios-cellular',
			'ios-chatboxes',
			'ios-chatbubbles',
			'ios-checkbox',
			'ios-checkbox-outline',
			'ios-checkmark',
			'ios-checkmark-circle',
			'ios-checkmark-circle-outline',
			'ios-clipboard',
			'ios-clock',
			'ios-close',
			'ios-close-circle',
			'ios-close-circle-outline',
			'ios-cloud',
			'ios-cloud-circle',
			'ios-cloud-done',
			'ios-cloud-download',
			'ios-cloud-outline',
			'ios-cloud-upload',
			'ios-cloudy',
			'ios-cloudy-night',
			'ios-code',
			'ios-code-download',
			'ios-code-working',
			'ios-cog',
			'ios-color-fill',
			'ios-color-filter',
			'ios-color-palette',
			'ios-color-wand',
			'ios-compass',
			'ios-construct',
			'ios-contact',
			'ios-contacts',
			'ios-contract',
			'ios-contrast',
			'ios-copy',
			'ios-create',
			'ios-crop',
			'ios-cube',
			'ios-cut',
			'ios-desktop',
			'ios-disc',
			'ios-document',
			'ios-done-all',
			'ios-download',
			'ios-easel',
			'ios-egg',
			'ios-exit',
			'ios-expand',
			'ios-eye',
			'ios-eye-off',
			'ios-fastforward',
			'ios-female',
			'ios-filing',
			'ios-film',
			'ios-finger-print',
			'ios-fitness',
			'ios-flag',
			'ios-flame',
			'ios-flash',
			'ios-flash-off',
			'ios-flashlight',
			'ios-flask',
			'ios-flower',
			'ios-folder',
			'ios-folder-open',
			'ios-football',
			'ios-funnel',
			'ios-gift',
			'ios-git-branch',
			'ios-git-commit',
			'ios-git-compare',
			'ios-git-merge',
			'ios-git-network',
			'ios-git-pull-request',
			'ios-glasses',
			'ios-globe',
			'ios-grid',
			'ios-hammer',
			'ios-hand',
			'ios-happy',
			'ios-headset',
			'ios-heart',
			'ios-heart-dislike',
			'ios-heart-empty',
			'ios-heart-half',
			'ios-help',
			'ios-help-buoy',
			'ios-help-circle',
			'ios-help-circle-outline',
			'ios-home',
			'ios-hourglass',
			'ios-ice-cream',
			'ios-image',
			'ios-images',
			'ios-infinite',
			'ios-information',
			'ios-information-circle',
			'ios-information-circle-outline',
			'ios-jet',
			'ios-journal',
			'ios-key',
			'ios-keypad',
			'ios-laptop',
			'ios-leaf',
			'ios-link',
			'ios-list',
			'ios-list-box',
			'ios-locate',
			'ios-lock',
			'ios-log-in',
			'ios-log-out',
			'ios-magnet',
			'ios-mail',
			'ios-mail-open',
			'ios-mail-unread',
			'ios-male',
			'ios-man',
			'ios-map',
			'ios-medal',
			'ios-medical',
			'ios-medkit',
			'ios-megaphone',
			'ios-menu',
			'ios-mic',
			'ios-mic-off',
			'ios-microphone',
			'ios-moon',
			'ios-more',
			'ios-move',
			'ios-musical-note',
			'ios-musical-notes',
			'ios-navigate',
			'ios-notifications',
			'ios-notifications-off',
			'ios-notifications-outline',
			'ios-nuclear',
			'ios-nutrition',
			'ios-open',
			'ios-options',
			'ios-outlet',
			'ios-paper',
			'ios-paper-plane',
			'ios-partly-sunny',
			'ios-pause',
			'ios-paw',
			'ios-people',
			'ios-person',
			'ios-person-add',
			'ios-phone-landscape',
			'ios-phone-portrait',
			'ios-photos',
			'ios-pie',
			'ios-pin',
			'ios-pint',
			'ios-pizza',
			'ios-planet',
			'ios-play',
			'ios-play-circle',
			'ios-podium',
			'ios-power',
			'ios-pricetag',
			'ios-pricetags',
			'ios-print',
			'ios-pulse',
			'ios-qr-scanner',
			'ios-quote',
			'ios-radio',
			'ios-radio-button-off',
			'ios-radio-button-on',
			'ios-rainy',
			'ios-recording',
			'ios-redo',
			'ios-refresh',
			'ios-refresh-circle',
			'ios-remove',
			'ios-remove-circle',
			'ios-remove-circle-outline',
			'ios-reorder',
			'ios-repeat',
			'ios-resize',
			'ios-restaurant',
			'ios-return-left',
			'ios-return-right',
			'ios-reverse-camera',
			'ios-rewind',
			'ios-ribbon',
			'ios-rocket',
			'ios-rose',
			'ios-sad',
			'ios-save',
			'ios-school',
			'ios-search',
			'ios-send',
			'ios-settings',
			'ios-share',
			'ios-share-alt',
			'ios-shirt',
			'ios-shuffle',
			'ios-skip-backward',
			'ios-skip-forward',
			'ios-snow',
			'ios-speedometer',
			'ios-square',
			'ios-square-outline',
			'ios-star',
			'ios-star-half',
			'ios-star-outline',
			'ios-stats',
			'ios-stopwatch',
			'ios-subway',
			'ios-sunny',
			'ios-swap',
			'ios-switch',
			'ios-sync',
			'ios-tablet-landscape',
			'ios-tablet-portrait',
			'ios-tennisball',
			'ios-text',
			'ios-thermometer',
			'ios-thumbs-down',
			'ios-thumbs-up',
			'ios-thunderstorm',
			'ios-time',
			'ios-timer',
			'ios-today',
			'ios-train',
			'ios-transgender',
			'ios-trash',
			'ios-trending-down',
			'ios-trending-up',
			'ios-trophy',
			'ios-tv',
			'ios-umbrella',
			'ios-undo',
			'ios-unlock',
			'ios-videocam',
			'ios-volume-high',
			'ios-volume-low',
			'ios-volume-mute',
			'ios-volume-off',
			'ios-walk',
			'ios-wallet',
			'ios-warning',
			'ios-watch',
			'ios-water',
			'ios-wifi',
			'ios-wine',
			'ios-woman',
			'logo-android',
			'logo-angular',
			'logo-apple',
			'logo-bitbucket',
			'logo-bitcoin',
			'logo-buffer',
			'logo-chrome',
			'logo-closed-captioning',
			'logo-codepen',
			'logo-css3',
			'logo-designernews',
			'logo-dribbble',
			'logo-dropbox',
			'logo-euro',
			'logo-facebook',
			'logo-flickr',
			'logo-foursquare',
			'logo-freebsd-devil',
			'logo-game-controller-a',
			'logo-game-controller-b',
			'logo-github',
			'logo-google',
			'logo-googleplus',
			'logo-hackernews',
			'logo-html5',
			'logo-instagram',
			'logo-ionic',
			'logo-ionitron',
			'logo-javascript',
			'logo-linkedin',
			'logo-markdown',
			'logo-model-s',
			'logo-no-smoking',
			'logo-nodejs',
			'logo-npm',
			'logo-octocat',
			'logo-pinterest',
			'logo-playstation',
			'logo-polymer',
			'logo-python',
			'logo-reddit',
			'logo-rss',
			'logo-sass',
			'logo-skype',
			'logo-slack',
			'logo-snapchat',
			'logo-steam',
			'logo-tumblr',
			'logo-tux',
			'logo-twitch',
			'logo-twitter',
			'logo-usd',
			'logo-vimeo',
			'logo-vk',
			'logo-whatsapp',
			'logo-windows',
			'logo-wordpress',
			'logo-xbox',
			'logo-xing',
			'logo-yahoo',
			'logo-yen',
			'logo-youtube',
			'md-add',
			'md-add-circle',
			'md-add-circle-outline',
			'md-airplane',
			'md-alarm',
			'md-albums',
			'md-alert',
			'md-american-football',
			'md-analytics',
			'md-aperture',
			'md-apps',
			'md-appstore',
			'md-archive',
			'md-arrow-back',
			'md-arrow-down',
			'md-arrow-dropdown',
			'md-arrow-dropdown-circle',
			'md-arrow-dropleft',
			'md-arrow-dropleft-circle',
			'md-arrow-dropright',
			'md-arrow-dropright-circle',
			'md-arrow-dropup',
			'md-arrow-dropup-circle',
			'md-arrow-forward',
			'md-arrow-round-back',
			'md-arrow-round-down',
			'md-arrow-round-forward',
			'md-arrow-round-up',
			'md-arrow-up',
			'md-at',
			'md-attach',
			'md-backspace',
			'md-barcode',
			'md-baseball',
			'md-basket',
			'md-basketball',
			'md-battery-charging',
			'md-battery-dead',
			'md-battery-full',
			'md-beaker',
			'md-bed',
			'md-beer',
			'md-bicycle',
			'md-bluetooth',
			'md-boat',
			'md-body',
			'md-bonfire',
			'md-book',
			'md-bookmark',
			'md-bookmarks',
			'md-bowtie',
			'md-briefcase',
			'md-browsers',
			'md-brush',
			'md-bug',
			'md-build',
			'md-bulb',
			'md-bus',
			'md-business',
			'md-cafe',
			'md-calculator',
			'md-calendar',
			'md-call',
			'md-camera',
			'md-car',
			'md-card',
			'md-cart',
			'md-cash',
			'md-cellular',
			'md-chatboxes',
			'md-chatbubbles',
			'md-checkbox',
			'md-checkbox-outline',
			'md-checkmark',
			'md-checkmark-circle',
			'md-checkmark-circle-outline',
			'md-clipboard',
			'md-clock',
			'md-close',
			'md-close-circle',
			'md-close-circle-outline',
			'md-cloud',
			'md-cloud-circle',
			'md-cloud-done',
			'md-cloud-download',
			'md-cloud-outline',
			'md-cloud-upload',
			'md-cloudy',
			'md-cloudy-night',
			'md-code',
			'md-code-download',
			'md-code-working',
			'md-cog',
			'md-color-fill',
			'md-color-filter',
			'md-color-palette',
			'md-color-wand',
			'md-compass',
			'md-construct',
			'md-contact',
			'md-contacts',
			'md-contract',
			'md-contrast',
			'md-copy',
			'md-create',
			'md-crop',
			'md-cube',
			'md-cut',
			'md-desktop',
			'md-disc',
			'md-document',
			'md-done-all',
			'md-download',
			'md-easel',
			'md-egg',
			'md-exit',
			'md-expand',
			'md-eye',
			'md-eye-off',
			'md-fastforward',
			'md-female',
			'md-filing',
			'md-film',
			'md-finger-print',
			'md-fitness',
			'md-flag',
			'md-flame',
			'md-flash',
			'md-flash-off',
			'md-flashlight',
			'md-flask',
			'md-flower',
			'md-folder',
			'md-folder-open',
			'md-football',
			'md-funnel',
			'md-gift',
			'md-git-branch',
			'md-git-commit',
			'md-git-compare',
			'md-git-merge',
			'md-git-network',
			'md-git-pull-request',
			'md-glasses',
			'md-globe',
			'md-grid',
			'md-hammer',
			'md-hand',
			'md-happy',
			'md-headset',
			'md-heart',
			'md-heart-dislike',
			'md-heart-empty',
			'md-heart-half',
			'md-help',
			'md-help-buoy',
			'md-help-circle',
			'md-help-circle-outline',
			'md-home',
			'md-hourglass',
			'md-ice-cream',
			'md-image',
			'md-images',
			'md-infinite',
			'md-information',
			'md-information-circle',
			'md-information-circle-outline',
			'md-jet',
			'md-journal',
			'md-key',
			'md-keypad',
			'md-laptop',
			'md-leaf',
			'md-link',
			'md-list',
			'md-list-box',
			'md-locate',
			'md-lock',
			'md-log-in',
			'md-log-out',
			'md-magnet',
			'md-mail',
			'md-mail-open',
			'md-mail-unread',
			'md-male',
			'md-man',
			'md-map',
			'md-medal',
			'md-medical',
			'md-medkit',
			'md-megaphone',
			'md-menu',
			'md-mic',
			'md-mic-off',
			'md-microphone',
			'md-moon',
			'md-more',
			'md-move',
			'md-musical-note',
			'md-musical-notes',
			'md-navigate',
			'md-notifications',
			'md-notifications-off',
			'md-notifications-outline',
			'md-nuclear',
			'md-nutrition',
			'md-open',
			'md-options',
			'md-outlet',
			'md-paper',
			'md-paper-plane',
			'md-partly-sunny',
			'md-pause',
			'md-paw',
			'md-people',
			'md-person',
			'md-person-add',
			'md-phone-landscape',
			'md-phone-portrait',
			'md-photos',
			'md-pie',
			'md-pin',
			'md-pint',
			'md-pizza',
			'md-planet',
			'md-play',
			'md-play-circle',
			'md-podium',
			'md-power',
			'md-pricetag',
			'md-pricetags',
			'md-print',
			'md-pulse',
			'md-qr-scanner',
			'md-quote',
			'md-radio',
			'md-radio-button-off',
			'md-radio-button-on',
			'md-rainy',
			'md-recording',
			'md-redo',
			'md-refresh',
			'md-refresh-circle',
			'md-remove',
			'md-remove-circle',
			'md-remove-circle-outline',
			'md-reorder',
			'md-repeat',
			'md-resize',
			'md-restaurant',
			'md-return-left',
			'md-return-right',
			'md-reverse-camera',
			'md-rewind',
			'md-ribbon',
			'md-rocket',
			'md-rose',
			'md-sad',
			'md-save',
			'md-school',
			'md-search',
			'md-send',
			'md-settings',
			'md-share',
			'md-share-alt',
			'md-shirt',
			'md-shuffle',
			'md-skip-backward',
			'md-skip-forward',
			'md-snow',
			'md-speedometer',
			'md-square',
			'md-square-outline',
			'md-star',
			'md-star-half',
			'md-star-outline',
			'md-stats',
			'md-stopwatch',
			'md-subway',
			'md-sunny',
			'md-swap',
			'md-switch',
			'md-sync',
			'md-tablet-landscape',
			'md-tablet-portrait',
			'md-tennisball',
			'md-text',
			'md-thermometer',
			'md-thumbs-down',
			'md-thumbs-up',
			'md-thunderstorm',
			'md-time',
			'md-timer',
			'md-today',
			'md-train',
			'md-transgender',
			'md-trash',
			'md-trending-down',
			'md-trending-up',
			'md-trophy',
			'md-tv',
			'md-umbrella',
			'md-undo',
			'md-unlock',
			'md-videocam',
			'md-volume-high',
			'md-volume-low',
			'md-volume-mute',
			'md-volume-off',
			'md-walk',
			'md-wallet',
			'md-warning',
			'md-watch',
			'md-water',
			'md-wifi',
			'md-wine',
			'md-woman'
	    );

	    
	    $ion_icons_args['skb_cife-ion-icon'] = array(
	        'name'          => 'skb_cife-ion-icon',
	        'label'         => esc_html__( 'Skyboot:: Ionicons', 'skb_cife' ),
	        'labelIcon'     => 'ion-logo-ionic',
	        'prefix'        => 'ion-',
	        'displayPrefix' => '',
	        'url'           => SKB_CIFE_ASSETS . 'css/ionicons.min.css',
	        'icons'         => $ion_icons,
	        'ver'           => SKB_CIFE_VERSION,
	    );

	    return $ion_icons_args;
	}



}
Skb_Cife_Ion_Icon_Manager::instance();